<x-app-layout>
    <x-slot name="header">
        Review
    </x-slot>

    <!-- Row -->
    <div class="row">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        @isset($review->id)
                        Edit Review
                        @else
                        Add New Review
                        @endisset
                    </div>
                </div>
                <form action="
                    @isset($review->id)
                        {{ route('user.review.update', $review->id) }}
                    @else
                        {{ route('user.review.store') }}
                    @endisset
                    " method="post" enctype="multipart/form-data">
                    <div class="card-body">
                        @isset($review->id)
                        @method('PUT')
                        @endisset
                        @csrf
                        <div class="row mb-4">
                            <div class="rating-stars block" id="rating" data-stars="{{$review->rating}}"></div>
                        </div>
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="content">Review:</label>
                            <div class="">
                                <textarea name="content" class="form-control @error('content') is-invalid @enderror"
                                    id="content" cols="30" rows="10"
                                    placeholder="Write Review">{{ old('content', $review->content) }}</textarea>
                            </div>
                            @error('content')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        @role('agent')
                        <label class="custom-switch form-switch me-5">
                            <input type="checkbox" name="published" value="1" class="custom-switch-input" {{
                                old('published', $review->published) == 1 ? 'checked' : '' }}>
                            <span class="custom-switch-indicator custom-switch-indicator-lg"></span>
                            <span class="custom-switch-description">Published</span>
                        </label>
                        @endrole
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Save</button>
                        <a href="{{route('user.review.index')}}" class="btn btn-default float-end">Discard</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Row -->
    <x-slot name="script">
        <script src="{{asset('backend/plugins/rating/jquery-rate-picker.js')}}"></script>
        <script>
            $(document).ready(function () {
                $.ratePicker("#rating");
            });
        </script>
    </x-slot>

</x-app-layout>
